definition module windowhandle


import	StdMaybe, StdWindowDef
from	oswindow  import OSWindowPtr
from	ospicture import OSPictContext, Origin, Pen, Font, 
							Colour, RGB, RGBColour, Black, White, DarkGrey, Grey, LightGrey, 
							Red, Green, Blue, Cyan, Magenta, Yellow
import	commondef, keyfocus, receiverhandle, receivertable


::	ControlState ls ps

::	WindowHandles ps											// Windows currently are only dialogs
	=	{	whsWindows		:: [WindowStateHandle ps]			// The windows and their controls of a process
//		,	whsCursorInfo	:: CursorInfo						// The global cursor information
		,	whsIds			:: [Int]							// The list of free system ids for windows
		,	whsNrWindowBound:: Bound							// The maximum number of windows that are allowed to be opened
		,	whsModal		:: Bool								// Flag: the window system is modal (used in combination with modal dialogues)
		}
::	WindowStateHandle ps
	=	E..ls:
		{	wshIds			:: WIDS								// A window is identified by an Id and an OSWindowPtr
		,	wshHandle		:: Maybe (WindowLSHandle ls ps)		// If used as placeholder, Nothing; otherwise window with local state
		}
::	WIDS
	=	{	wId				:: Id								// Id  of window
		,	wPtr			:: !OSWindowPtr						// Ptr of window
		}
::	WindowLSHandle ls ps
	=	{	wlsState		:: ls								// The local state of this window
		,	wlsHandle		:: WindowHandle ls ps				// The window implementation
		}
::	WindowHandle ls ps
	=	{	whMode			:: WindowMode						// The window mode (Modal or Modeless)
		,	whKind			:: WindowKind						// The window kind (Window or Dialog)
		,	whTitle			:: Title							// The window title
		,	whItemNrs		:: [Int]							// The list of free system item numbers for all controls
		,	whKeyFocus		:: KeyFocus							// The item that has the keyboard input focus
		,	whWindowInfo	:: Maybe WindowInfo					// Additional information about the Window (Nothing for Dialogs)
		,	whItems			:: [WElementHandle ls ps]			// The window controls
		,	whShow			:: Bool								// The visibility of the window (True iff visible)
		,	whSelect		:: Bool								// The WindowSelectState==Able (by default True)
		,	whAtts			:: [WindowAttribute *(ls,ps)]		// The window attributes
		,	whDefaultId		:: Maybe Id							// The Id of the optional default button
		,	whCancelId		:: Maybe Id							// The Id of the optional cancel  button
		,	whSize			:: Size								// The exact size of the window
		}
::	WindowMode													// Modality of the window
	=	Modal													// Modal window (only for dialogs)
	|	Modeless												// Modeless window
::	WindowKind
	=	IsWindow												// Window kind
	|	IsDialog												// Dialog kind
::	LookInfo
	=	{	lookFun			:: Look								// The Look function
		,	lookPen			:: Pen								// The settings of the Pen
		}
::	WindowInfo
	=	{	windowDomain	:: ViewDomain						// The optional view domain of the window
		,	windowOrigin	:: Point							// The Origin of the view domain
		,	windowHScroll	:: Maybe ScrollInfo					// The scroll data of the WindowHScroll attribute
		,	windowVScroll	:: Maybe ScrollInfo					// The scroll data of the WindowVScroll attribute
		,	windowLook		:: LookInfo							// The look and pen of the window
		,	windowClip		:: ClipState						// The clipped elements of the window
		}
::	ScrollInfo
	=	{	scrollFunction	:: ScrollFunction					// The ScrollFunction of the (horizontal/vertical) scroll attribute
		,	scrollItemPos	:: Point							// The exact position of the scrollbar
		,	scrollItemSize	:: Size								// The exact size of the scrollbar
		,	scrollItemPtr	:: OSWindowPtr						// The OSWindowPtr of the scrollbar
		}
::	ClipState
	=	{	clipRgn			:: !OSRgnHandle						// The clipping region
		,	clipOk			:: !Bool							// Flag: the clipping region is valid
		}
::	WElementHandle	ls	ps
	=	WItemHandle			(WItemHandle		ls ps)
	|	WListLSHandle		[WElementHandle		ls ps]
	|	WExtendLSHandle		(WExtendLSHandle	ls ps)
	|	WChangeLSHandle		(WChangeLSHandle	ls ps)
::	WExtendLSHandle	ls ps
	=	E..ls1:
		{	wExtendLS		:: ls1
		,	wExtendItems	:: [WElementHandle *(ls1,ls) ps]
		}
::	WChangeLSHandle	ls ps
	=	E..ls1:
		{	wChangeLS		:: ls1
		,	wChangeItems	:: [WElementHandle ls1 ps]
		}
::	WItemHandle		ls ps
	=	{	wItemId			:: Maybe Id							// If the control has a (ControlId id) attribute, then Just id; Nothing
		,	wItemNr			:: Int								// The internal nr of this control  (generated from whItemNrs)
		,	wItemKind		:: ControlKind						// The sort of control
		,	wItemShow		:: Bool								// The visibility of the control (True iff visible)
		,	wItemSelect		:: Bool								// The ControlSelectState==Able  (by default True)
		,	wItemInfo		:: WItemInfo ls ps					// Additional information of the control
		,	wItemAtts		:: [ControlAttribute *(ls,ps)]		// The control attributes
		,	wItems			:: [WElementHandle ls ps]			// In case of	CompoundControl	: its control elements
																//				Otherwise		: []
		,	wItemPos		:: Point							// The exact position of the item
		,	wItemFixedPos	:: Bool								// The layout of the item is either Fix or relative to a Fix item
		,	wItemSize		:: Size								// The exact size of the item
		,	wItemPtr		:: OSWindowPtr						// The ptr to the item (OSNoWindowPtr if no handle)
		}
::	WItemInfo		ls ps
	=	RadioInfo			(RadioInfo	  *(ls,ps))				// In case of	RadioControl	: the radio items information
	|	CheckInfo			(CheckInfo	  *(ls,ps))				// In case of	CheckControl	: the check items information
	|	PopUpInfo			(PopUpInfo	  *(ls,ps))				// In case of	PopUpControl	: the pop up information
	|	SliderInfo			(SliderInfo	  *(ls,ps))				// In case of	SliderControl	: the slider information
	|	TextInfo			TextInfo							// In case of	TextControl		: the text information
	|	EditInfo			EditInfo							// In case of	EditControl		: the edit text information
	|	ButtonInfo			ButtonInfo							// In case of	ButtonControl	: the button information
	|	CustomButtonInfo	CustomButtonInfo					// In case of	CustomButtonControl	: the custom button information
	|	CustomInfo			CustomInfo							// In case of	CustomControl		: the custom information
	|	CompoundInfo		CompoundInfo						// In case of	CompoundControl	: the compound control information
	|	ReceiverInfo		(ReceiverHandle	ls ps)				// In case of	ReceiverControl	: the receiver information
	|	NoWItemInfo												// No additional information
::	RadioInfo		ps
	=	{	radioItems		:: [RadioItemInfo ps]				// The radio items and their exact position (initially zero)
		,	radioLayout		:: RowsOrColumns					// The layout of the radio items
		,	radioIndex		:: Int								// The currently selected radio item (1<=radioIndex<=length radioItems)
		}
::	RadioItemInfo	ps
	=	{	radioItem		:: RadioControlItem ps				// The RadioItem of the definition
		,	radioItemPos	:: !Point							// The exact position of the item
		,	radioItemSize	:: Size								// The exact size of the item
		,	radioItemPtr	:: OSWindowPtr						// The OSWindowPtr of the item
		}
::	CheckInfo		ps
	=	{	checkItems		:: [CheckItemInfo ps]				// The check items and their exact position (initially zero)
		,	checkLayout		:: RowsOrColumns					// The layout of the check items
		}
::	CheckItemInfo	ps
	=	{	checkItem		:: CheckControlItem ps				// The CheckItem of the definition
		,	checkItemPos	:: !Point							// The exact position of the item
		,	checkItemSize	:: Size								// The exact size of the item
		,	checkItemPtr	:: OSWindowPtr						// The OSWindowPtr of the item
		}
::	PopUpInfo		ps
	=	{	popUpInfoItems	:: [PopUpControlItem ps]			// The pop up items
		,	popUpInfoIndex	:: Index							// The currently selected pop up item (1<=popUpInfoIndex<=length popUpInfoItems)
		}
::	SliderInfo		ps
	=	{	sliderInfoDir	:: Direction						// The direction of the slider
		,	sliderInfoLength:: Length							// The length (in pixels) of the slider
		,	sliderInfoState	:: SliderState						// The current slider state
		,	sliderInfoAction:: SliderAction ps					// The action of the slider
		}
::	TextInfo
	=	{	textInfoText	:: TextLine							// The content of the text control
		}
::	EditInfo
	=	{	editInfoText	:: !TextLine						// The content of the edit control
		,	editInfoWidth	:: Width							// The width (in pixels) of the edit item
		,	editInfoNrLines	:: NrLines							// The nr of complete visible lines of the edit item
		}
::	ButtonInfo
	=	{	buttonInfoText	:: TextLine							// The title of the button control
		}
::	CustomButtonInfo
	=	{	cButtonInfoLook	:: LookInfo							// The look of the custom button control
		}
::	CustomInfo
	=	{	customInfoLook	:: LookInfo							// The look of the custom control
		}
::	CompoundInfo
	=	{	compoundDomain	:: ViewDomain						// The optional view domain of the compound control
		,	compoundOrigin	:: Point							// The Origin of the view domain
		,	compoundHScroll	:: Maybe ScrollInfo					// The scroll data of the ControlHScroll attribute
		,	compoundVScroll	:: Maybe ScrollInfo					// The scroll data of the ControlVScroll attribute
		,	compoundLookInfo:: Maybe CompoundLookInfo			// The look information of the compound control
		}
::	CompoundLookInfo
	=	{	compoundLook	:: LookInfo							// The look of the compound control
		,	compoundClip	:: ClipState						// The clipped elements of the compound control
		}
::	ControlKind
	=	IsRadioControl
	|	IsCheckControl
	|	IsPopUpControl
	|	IsSliderControl
	|	IsTextControl
	|	IsEditControl
	|	IsButtonControl
	|	IsCustomButtonControl
	|	IsCustomControl
	|	IsCompoundControl
	|	IsOtherControl ControlType								// Of other controls the non LS variant

instance == WIDS
instance == WindowMode
instance == WindowKind
instance == ControlKind
instance toString ControlKind
isCustomisedControl	:: !ControlKind -> Bool
isRecursiveControl	:: !ControlKind -> Bool


//	Conversion functions from ControlState to WElementHandle, and vice versa:
WElementHandleToControlState:: !(WElementHandle .ls .ps) -> ControlState   .ls .ps
ControlStateToWElementHandle:: !(ControlState   .ls .ps) -> WElementHandle .ls .ps

//	Bind all free R(2)Ids that are contained in the WElementHandles.
bindReceiverControlIds		:: !SystemId !Id ![WElementHandle .ls .ps] !ReceiverTable -> (!Bool,![WElementHandle .ls .ps],!ReceiverTable)

//	Retrieve the FocusItems of the elements that can obtain the keyboard input focus.
getWElementKeyFocusIds		:: !Bool ![WElementHandle .ls .ps] -> (![FocusItem],![WElementHandle .ls .ps])

//	Generate internal item numbers for those WElementHandles that have none (wItemNr==0).
genWElementItemNrs			:: ![Int] ![WElementHandle .ls .ps] -> (![Int],![WElementHandle .ls .ps])
